#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


#define BGM_FILE	"ssntr_bgm_tmp.dat"
#define MAX_BGM		20

int bgmtable[MAX_BGM][3]={
	{0x144411E4, 0x00142FA8, 0x0054C928},
	{0x078AF814, 0x00184AC4, 0x00DA1748},
	{0x0000002C, 0x000E5F70, 0x007265E4},
	{0x097FA5A8, 0x001A8BEC, 0x015D8B58},
	{0x007EC5C8, 0x001951C0, 0x00A321C0},
	{0x0AFEA1E4, 0x001CB5F8, 0x01753E04},
	{0x01CB67F0, 0x003CACBC, 0x00F25C74},
	{0x0C909658, 0x00236844, 0x01143008},
	{0x02C9A594, 0x001BC6D0, 0x00B8A944},
	{0x0F335700, 0x0281A5EC, 0x03702B78},

	{0x045E7AA0, 0x002BA8E0, 0x00F26114},
	{0x0DC21964, 0x005B54C8, 0x01516CC8},
	{0x0394B484, 0x0012E674, 0x00AAE638},
	{0x12ACD5C0, 0x006830C0, 0x017D0BF4},
	{0x05626C3C, 0x003B549C, 0x00F8670C},
	{0x066274A0, 0x00000000, 0x00112C54},
	{0x0673A120, 0x00000000, 0x0109948C},
	{0x08854DC0, 0x00184AC4, 0x00DA1748},
	{0x0122EEE8, 0x001951C0, 0x00A321C0},
	{0x077D35D8, 0x00000000, 0x000DC210}
};

char bgmfile[MAX_BGM][50]={
	"01 ^Cg.wav",
	"02 STAGE1 ̑.wav",
	"03 STAGE1 {X.wav",
	"04 STAGE2 lԂ̗.wav",
	"05 STAGE2 {X.wav",
	"06 STAGE3 i.wav",
	"07 STAGE3 {X.wav",
	"08 STAGE4 g.wav",
	"09 STAGE4 {X.wav",
	"10 STAGE5 n.wav",

	"11 STAGE5 {X.wav",
	"12 STAGE6 z.wav",
	"13 STAGE6 {X.wav",
	"14 STAGE7 z.wav",
	"15 STAGE7 {X.wav",
	"16 Xe[WNA.wav",
	"17 GfBO.wav",
	"18 STAGE1 ver.wav",
	"19 STAGE2 {X ver.wav",
	"20 Q[I[o[.wav"
};

void makeheader(char *header,int datasize){
	int i;
	short s;
	memcpy(header,"RIFF",4);
	i = datasize + 36;
	memcpy(header+4,&i,4);
	memcpy(header+8,"WAVEfmt ",8);
	i = 16;
	memcpy(header+16,&i,4);
	s = 1;
	memcpy(header+20,&s,2);
	s = 2;
	memcpy(header+22,&s,2);
	i = 44100;
	memcpy(header+24,&i,4);
	i = 176400;
	memcpy(header+28,&i,4);
	s = 4;
	memcpy(header+32,&s,2);
	s = 16;
	memcpy(header+34,&s,2);
	memcpy(header+36,"data",4);
	i = datasize;
	memcpy(header+40,&i,4);

}

int main(int argc,char *argv[]){
	FILE *datf,*bgmf;
	int i,j,l,k;
	int rep=2;
	int length;
	int fade=0;
	int fadep=0;
	int ts=0;
	int te=MAX_BGM;
	char header[44];
	short buf[44100*2];
	int s,e;
	double d;


	//bgmtable(JnAJԂn_܂ł̒AI_܂ł̒)Ȃ̂
	//ꂼʒuɊZ
	for(i=0;i<MAX_BGM;i++){
		bgmtable[i][1]+=bgmtable[i][0];
		bgmtable[i][2]+=bgmtable[i][0];
	}

	//argc̃`FbN
	for(i=1;i<argc;i++){
		switch(argv[i][0]){
		case 'f' :
			argv[i]++; fade=atoi(argv[i]); break;
		case 'F' :
			argv[i]++; fade=-atoi(argv[i]); break;
		case 'P' :
		case 'p' :
			argv[i]++; fadep=atoi(argv[i]); break;
		case 'T' :
		case 't' :
			argv[i]++; ts=te=atoi(argv[i]); break;
		default:
			rep=atoi(argv[i]);
		}
	}

	if(rep<1 || rep>10){
		printf("repeat must be 1-10\n");
		return 0;
	}
	if(fade<-30 || fade>30){
		printf("fade must be 0-30\n");
		return 0;
	}
	if(fadep<0 || fadep>3){
		printf("fade pattern must be 0-3\n");
		return 0;
	}
	if(ts<0 || te>MAX_BGM){
		printf("track number must be 1-%d\n", MAX_BGM);
		return 0;
	}


	printf("track=%d-%d , repeat=%d , fade=%d , fade pattern=%d\n",ts+1,te,rep,fade,fadep);
	if(ts) ts--;

	datf=fopen(BGM_FILE,"rb");
	if(datf==NULL){
		printf("%s not found.", BGM_FILE);
		return 0;
	}

	//Jn
	for(i=ts;i<te;i++){

		printf("Create %s ...\n",bgmfile[i]);
		bgmf=fopen(bgmfile[i],"wb");
		length=(bgmtable[i][2]-bgmtable[i][0])+(bgmtable[i][2]-bgmtable[i][1])*(rep-1);
		if(fade<0) length+=(-fade)*44100*4;
		makeheader(header,length);
		fwrite(header,1,44,bgmf);

		//[v
		for(k=0;k<rep;k++){
			//[
			s=bgmtable[i][1];
			if(k==0) s=bgmtable[i][0];

			//I[
			e=bgmtable[i][2];
			if(k==rep-1 && fade>0) e=bgmtable[i][2]-fade*44100*4;

			for(j=s;j<e;j+=44100*4){
				if(j+44100*4>e) l=e-j;
				else l=44100*4;

				fseek(datf,j,SEEK_SET);
				fread(buf,1,l,datf);
				fwrite(buf,1,l,bgmf);
			}
		}

		//tF[hAEg
		if(fade>0){
			//[vI[
			s=bgmtable[i][2]-fade*44100*4;
			e=bgmtable[i][2];
		}
		else if(fade<0){
			//[v[
			s=bgmtable[i][1];
			e=s-fade*44100*4;
		}
		else{
			s=e=0;
		}

		for(j=s;j<e;j+=44100*4){
			if(j+44100*4>e) l=e-j;
			else l=44100*4;

			fseek(datf,j,SEEK_SET);
			fread(buf,1,l,datf);
			for(k=0;k<l/4;k++){
				switch (fadep) {
				case 0 :
					d=(float)((j-s)/4+k)/(abs(fade)*44100);
					d=pow(0.001,d);
					break;
				case 1 :
					d=1-(float)((j-s)/4+k)/(abs(fade)*44100);
					break;
				case 2 :
					d=(float)((j-s)/4+k)/(abs(fade)*44100);
					d=(pow(0.001,d)+(1-d))/2;
					break;
				case 3 :
					d=(cos(3.1415926535*(float)((j-s)/4+k)/(abs(fade)*44100))+1)/2;
					break;
				}

				buf[2*k]=(short)(buf[2*k]*d);
				buf[2*k+1]=(short)(buf[2*k+1]*d);
			}
			fwrite(buf,1,l,bgmf);
		}

		fclose(bgmf);
	}
	fclose(datf);

	return 0;
}
